package ;

import flixel.util.FlxColor;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.display.BitmapData;
import flixel.FlxSprite;

class CanvasSprite extends FlxSprite
{
	var drawSurface = new Sprite();
	var drawMatrix:Matrix;
	var inverseDrawMatrix:Matrix;

	public function new(drawMatrix_:Matrix)
	{
		super(0,0);
		drawMatrix = drawMatrix_;
		inverseDrawMatrix = drawMatrix.clone();
		inverseDrawMatrix.invert();
	}

	public function clear()
	{
		drawSurface.graphics.clear();
		_flashRect.setTo(0,0,framePixels.width, framePixels.height);
		framePixels.fillRect(_flashRect, FlxColor.TRANSPARENT);
	}

	public function beginPatternDraw(pattern:BitmapData, wantClear:Bool=true):Graphics
	{
		drawSurface.graphics.endFill();
		if (wantClear) clear();
		drawSurface.graphics.beginBitmapFill(pattern, inverseDrawMatrix);
		return drawSurface.graphics;
	}

	public function beginSolidDraw(color:Int, wantClear:Bool=true):Graphics
	{
		drawSurface.graphics.endFill();
		if (wantClear) clear();
		drawSurface.graphics.beginFill(color);
		return drawSurface.graphics;
	}

//	public function beginLine(color:Int):Graphics
//	{
//		drawSurface.graphics.endFill();
//		if (wantClear) clear();
//		drawSurface.graphics.beginFill(color);
//		return drawSurface.graphics;
//	}

	public function endDraw()
	{
		drawSurface.graphics.endFill();
		framePixels.draw(drawSurface, drawMatrix, null, null, null, false);
	}
}
