package ;

import flixel.util.FlxPoint;
import flixel.FlxG;
import flixel.FlxSprite;

class ImageButton extends FlxSprite
{
	var pressing:Bool;
	var onClick:Void->Void;

	public function new(x_:Int, y_:Int, imageFilename:String, ?onClick_:Void->Void)
	{
		super(x_, y_);
		var bitmapData = openfl.Assets.getBitmapData("assets/images/" + imageFilename);
		loadGraphic(bitmapData, true, Std.int(bitmapData.width/2), bitmapData.height);
		onClick = onClick_;
	}

	public override function update()
	{
		var mouseOver = this.overlapsPoint(new FlxPoint(FlxG.mouse.screenX, FlxG.mouse.screenY));

		if (pressing)
		{
			if (!FlxG.mouse.pressed)
			{
				// click
				pressing = false;
				if (mouseOver && onClick != null) onClick();
				frame = framesData.frames[0];
			}
			else
			{
				frame = framesData.frames[mouseOver ? 1 : 0];
			}
		}
		else if (mouseOver && FlxG.mouse.justPressed)
		{
			pressing = true;
			frame = framesData.frames[1];
		}
	}
}
