package;

import search.Config;
import search.Area;
import flash.geom.Point;
import flixel.util.FlxRect;
import flixel.util.FlxPoint;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.FlxState;
import flixel.text.FlxText;
import flixel.ui.FlxButton;
import flixel.util.FlxMath;

class MissingState extends FlxState
{
	override public function create():Void
	{
		super.create();

		var background = new FlxSprite(0,0);
		background.loadGraphic("assets/images/Screen-Missing.png");
		add(background);

		var textY = 110;
		for (config in search.Config.Helper.all)
		{
			var str = "";
			if (config.numTargets == 1) str = "1 Wreck - ";
			else str = '${config.numTargets} Wrecks - ';
			str += (config.numTargets * config.numPeoplePerTarget) + " People - ";
			str += (config.dim.x * config.dim.y) + "^2 km of ocean";

			var button = new ImageButton(400, textY, "Button-MissingPlay.png", onSearchClicked.bind(config));
			add(button);

			var text = Util.makeText(str, 400-30, Main.BLUE, "right");
			text.x = 20;
			text.y = textY;
			add(text);

			textY += 25;
		}

		var backButton = new ImageButton(20, 305, "Button-MissingBack.png", onBackClicked);
		add(backButton);
	}

	override public function destroy():Void
	{
		super.destroy();
	}

	function onSearchClicked(config:Config)
	{
		PrepareState.config = config;
		FlxG.switchState(new PrepareState());
	}

	function onBackClicked()
	{
		FlxG.switchState(new TitleState());
	}

	override public function update():Void
	{
		super.update();
	}
}