package;

import flash.geom.Rectangle;
import search.Config;
import search.Area;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flixel.util.FlxRect;
import flixel.util.FlxPoint;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.FlxState;
import flixel.text.FlxText;
import flixel.ui.FlxButton;
import flixel.util.FlxMath;

class PrepareState extends FlxState
{
	var iconGrid:IconGrid;
	var searchArea:Area;
	var infoPanel:ToolInfoPanel;
	var needSubDialog:FlxSprite;

	public static var config:search.Config;
	public static var selectedToolConfigs:Array<ToolConfig> = [];

	override public function create():Void
	{
		super.create();

		searchArea = new Area(new FlxRect(128, 166, 250, 130), new Point(config.dim.x, config.dim.y));
		add(searchArea.group);

		var background = new FlxSprite(0,0);
		background.loadGraphic("assets/images/Screen-Prepare.png");
		add(background);

		var loadoutRect = new Rectangle(356, 55, 130, 100);
		var loadoutPos = new FlxPoint(
			loadoutRect.x + loadoutRect.width*0.5 - 10*config.toolSpace.x*0.5,
			loadoutRect.y + loadoutRect.height*0.5 - 10*config.toolSpace.y*0.5
		);
		iconGrid = new IconGrid(loadoutPos, new FlxPoint(config.toolSpace.x, config.toolSpace.y));
		add(iconGrid);

		infoPanel = new ToolInfoPanel(new FlxPoint(17, 166), 100, 387);
		add(infoPanel);

		var stacks = new Array<IconStack>();
		var stackX = 27.0;
		var stackY = 60.0;
		var stackMaxHeight = 0.0;
		for (toolConfig in config.toolConfigs)
		{
			var toolSpec = ToolSpec.Helper.find(toolConfig.id);
			var stack = new IconStack(new FlxPoint(stackX, stackY), toolSpec, toolConfig.count);
			stackMaxHeight = Math.max(stackMaxHeight, stack.height);
			stackX += stack.width+10;//Math.floor(((stack.width+5)/10))*10+10;
			if (stackX >= 280)
			{
				stackX = 27;
				stackY += stackMaxHeight;
				stackMaxHeight = 0;
			}
			stacks.push(stack);
			add(stack);
		}

		var backButton = new ImageButton(17, 314, "Button-PrepareBack.png", backButton_onClick);
		add(backButton);

		var searchButton = new ImageButton(422, 314, "Button-PrepareSearch.png", searchButton_onClick);
		add(searchButton);

		var draggingIcon = new DraggingIcon(stacks, iconGrid, null);
		add(draggingIcon);

		draggingIcon.whenMouseDown = draggingIcon_whenMouseDown;
	}

	function backButton_onClick()
	{
		FlxG.switchState(new MissingState());
	}

	function searchButton_onClick()
	{
		// collect selected toolSpecs
		var numSubs = 0;

		selectedToolConfigs = [];
		for (m in iconGrid.members)
		{
			if (!Std.is(m, Icon)) continue;
			var icon:Icon = cast(m, Icon);
			var foundToolConfig = false;
			if (icon.toolSpec.id == "sub") numSubs++;

			for (s in selectedToolConfigs)
			{
				if (s.id == icon.toolSpec.id) { s.count++; foundToolConfig = true; break; }
			}
			if (!foundToolConfig)
			{
				selectedToolConfigs.push( { id:icon.toolSpec.id, count:1 } );
			}
		}

		if (numSubs == 0)
		{
			// show dialog about needing at least one sub for recovery
			if (needSubDialog == null)
			{
				needSubDialog = new FlxSprite(0,0);
				needSubDialog.loadGraphic("assets/images/Dialog-NeedSub.png");
				add(needSubDialog);
			}
			else
			{
				needSubDialog.visible = true;
			}
		}
		else
		{
			// play!
			FlxG.switchState(new PlayState());
		}
	}

	function draggingIcon_whenMouseDown(icon:Icon)
	{
		var spec = (icon == null) ? null : icon.toolSpec;
		infoPanel.set(spec);
		searchArea.demoTool(spec);
	}

	override public function destroy():Void
	{
		super.destroy();
	}

	override public function update():Void
	{
		super.update();
		searchArea.update();

		if (needSubDialog != null && needSubDialog.visible == true && FlxG.mouse.justPressed)
			needSubDialog.visible = false;
	}
}