package;

import search.Area;
import flash.geom.Point;
import flixel.util.FlxRect;
import flixel.util.FlxPoint;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.FlxState;
import flixel.text.FlxText;
import flixel.ui.FlxButton;
import flixel.util.FlxMath;

class ResultState extends FlxState
{
	var clock:Clock = new Clock();
	var flashingTitleText:FlxSprite;

	public static var numWrecksFound:Int = 0;
	public static var numSaved:Int = 0;
	public static var numLost:Int = 0;

	override public function create():Void
	{
		super.create();

		var background = new FlxSprite(0,0);
		background.loadGraphic("assets/images/Screen-Result.png");
		add(background);

		flashingTitleText = new FlxSprite(0,0);
		if (numSaved > 0 && numLost == 0) flashingTitleText.loadGraphic("assets/images/Screen-ResultAll.png");
		else if (numSaved > 0) flashingTitleText.loadGraphic("assets/images/Screen-ResultSome.png");
		else flashingTitleText.loadGraphic("assets/images/Screen-ResultNone.png");
		add(flashingTitleText);

		var resultStr0 = switch(numWrecksFound) {
			case 0: "Recovered nothing";
			case 1: "Recovered one wreck";
			default: 'Recovered $numWrecksFound wrecks';
		}
		var resultStr1 = switch(numSaved) {
			case 0: "Saved no one";
			case 1: "Saved one lucky soul";
			default: 'Saved $numSaved desperate souls';
		}
		var resultStr2 = switch(numLost) {
			case 0: "Lost no one to the sea";
			case 1: "Lost one to the sea";
			default: 'Lost $numLost to the sea';
		}

		var textY = 226;
		for (r in [ resultStr0, resultStr1, resultStr2 ])
		{
			var text = Util.makeText(r, 400, Main.GREEN);
			text.x = Math.floor(512/2 - text.width/2);
			text.y = textY;
			add(text);
			textY += 30;
		}

		var nextButton = new ImageButton(430, 295, "Button-ResultNext.png", onNextClicked);
		add(nextButton);
	}

	override public function destroy():Void
	{
		super.destroy();
	}

	function onNextClicked()
	{
		FlxG.switchState(new TitleState());
	}

	override public function update():Void
	{
		super.update();
		clock.update();
		flashingTitleText.visible = clock.getFlashing(1, 0.75);
	}
}