package ;

import search.ToolSub;
import search.ToolSonicBuoy;
import search.ToolRadioBuoy;
import search.ToolGangWander;
import search.ToolGangLine;
import search.ToolFlyby;
import search.ToolSteve;
import search.ToolGps;
import search.ToolPath;
import search.Placer;

typedef ToolSpec =
{
	public var id:String;
	public var name:String;
	public var description:String;
	public var errorRate:Float;
	public var className:String;
	public var iconFilename:String;
	public var photoFilename:String;
	public var placerType:search.Placer.SearchPlacerType;
	public var iconUseSecondFrameOnArea:Bool;
}

class Helper
{
	public static var all:Array<ToolSpec> =
	[
		{ 	id: "sub",
			name: "Submersible",
			errorRate: ToolSub.kErrorRate,
			className: "search.ToolSub",
			iconFilename: "Icon-Sub.png",
			photoFilename: "Photo-Sub.png",
			description: "REQUIRED - Use for rescue when target is known",
			placerType: search.Placer.SearchPlacerType.CIRCLE(ToolSub.kFindRadius),
			iconUseSecondFrameOnArea: true
		},
		{ 	id: "sonic",
			name: "Sonic Buoy",
			errorRate: ToolSonicBuoy.kErrorRate,
			className: "search.ToolSonicBuoy",
			iconFilename: "Icon-SonicBuoy.png",
			photoFilename: "Photo-SonicBuoy.png",
			description: "Use coded pings to detect distance to target",
			placerType: search.Placer.SearchPlacerType.CIRCLE(ToolSonicBuoy.kMaxRadius),
			iconUseSecondFrameOnArea: false
		},
		{ 	id: "radio",
			name: "Radio Buoy",
			errorRate: ToolRadioBuoy.kErrorRate,
			className: "search.ToolRadioBuoy",
			iconFilename: "Icon-RadioBuoy.png",
			photoFilename: "Photo-RadioBuoy.png",
			description: "Use radio pings to detect angle to target",
			placerType: search.Placer.SearchPlacerType.CIRCLE(ToolRadioBuoy.kMaxRadius),
			iconUseSecondFrameOnArea: false
		},
		{	id: "randomboats",
			name: "Wandering Boats",
			errorRate: ToolGangWander.kErrorRate,
			className: "search.ToolGangWander",
			iconFilename: "Icon-GangWander.png",
			photoFilename: "Photo-GangWander.png",
			description: "Search entire area randomly",
			placerType: search.Placer.SearchPlacerType.GLOBAL,
			iconUseSecondFrameOnArea: false
		},
		{ 	id: "lineboats",
			name: "Lined Boats",
			errorRate: ToolGangLine.kErrorRate,
			className: "search.ToolGangLine",
			iconFilename: "Icon-GangLine.png",
			photoFilename: "Photo-GangLine.png",
			description: "Search in a moving line",
			placerType: search.Placer.SearchPlacerType.SEGMENT(ToolGangLine.kLineWidth, ToolGangLine.kLineLen),
			iconUseSecondFrameOnArea: false
		},
		{
			id: "flyby",
			name: "Fly by",
			errorRate: ToolFlyby.kErrorRate,
			className: "search.ToolFlyby",
			iconFilename: "Icon-Flyby.png",
			photoFilename: "Photo-Flyby.png",
			description: "Airplane fly by",
			placerType: search.Placer.SearchPlacerType.LINE(ToolFlyby.kLineWidth),
			iconUseSecondFrameOnArea: false
		},
		{ 	id: "steve",
			name: "Steve",
			errorRate: ToolSteve.kErrorRate,
			className: "search.ToolSteve",
			iconFilename: "Icon-Steve.png",
			photoFilename: "Photo-Steve.png",
			description: "Killer binocs and a sweet-ass boat. Living the dream.",
			placerType: search.Placer.SearchPlacerType.GLOBAL,
			iconUseSecondFrameOnArea: false
		},
		{ 	id: "gps",
			name: "GPS Scan",
			errorRate: ToolGps.kErrorRate,
			className: "search.ToolGps",
			iconFilename: "Icon-Gps.png",
			photoFilename: "Photo-Gps.png",
			description: "Systematic scan of all sectors for a GPS signal",
			placerType: search.Placer.SearchPlacerType.GLOBAL,
			iconUseSecondFrameOnArea: false
		},
		{ 	id: "path",
			name: "Path Analysis",
			errorRate: ToolPath.kErrorRate,
			className: "search.ToolPath",
			iconFilename: "Icon-Path.png",
			photoFilename: "Photo-Path.png",
			description: "Analyze travel path before wreck",
			placerType: search.Placer.SearchPlacerType.GLOBAL,
			iconUseSecondFrameOnArea: false
		}
	];

	public static function find(id:String):ToolSpec
	{
		for (spec in all)
		{
			if (spec.id == id) return spec;
		}
		return null;
	}
}