package search;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flash.geom.Point;
import flash.display.Graphics;

class ToolGangLine extends ToolBoats
{
	public static var kErrorRate = 0.3;
	public static var kAcquireTime = 20;
	public static var kLineWidth = 5;
	public static var kLineLen = 10;

	public function new(area_:Area, c0:Point, c1:Point)
	{
		super(area_, kErrorRate);

		var coords = c0;
		var heading = Util.normalize(Util.sub(c1, c0));
		var perp = Util.perp(heading);

		var a = Util.add(coords, Util.mul(kLineWidth*0.5, perp));
		var b = Util.add(coords, Util.mul(-kLineWidth*0.5, perp));

		var numBoats = 10;
		for (i in 0...numBoats)
		{
			var t = (i + 0.2*Math.random()) / numBoats;
			var boat = new Boat(area,
				"Tool-Boat.png",
				Util.lerp(0.006, 0.008, Math.random()), // speed
				Util.lerp(0.8, 1.25, Math.random()), // sightRadius
				targets
			);
			var w0 = Util.plerp(a, b, t);
			var w1 = Util.add(w0, Util.mul(kLineLen, heading));
			boat.setWaypoints([w0, w1], true);
			addBoat(boat);
		}
	}
}

