package search;

import flash.geom.Point;

class ToolSub extends Tool
{
	var coords:Point;
	var findTime:Float;
	var foundTarget:Target;
	var foundCoords:Point;
	public var done(default,null):Bool;

	public static var kErrorRate = 0;
	public static var kFindRadius = 0.25;

	public function new(area_:Area, c0:Point, c1:Point=null)
	{
		super(area_, kErrorRate);
		super.makePixelSprite("Tool-Sub.png");
		coords = c0;
		findTime = 0;
	}

	public override function update()
	{
		super.update();

		if (foundTarget != null)
		{
			if (!done && clock.time > findTime && foundTarget.isReal)
			{
				pixelSprite.loadGraphic("assets/images/Tool-Rescued.png");
				coords = foundCoords;
				done = true;
				var foundTargetWasAlreadyRecovered = foundTarget.recovered;
				foundTarget.recovered = true;
				area.registerSubFinished(foundTarget, !foundTargetWasAlreadyRecovered);
			}
		}
		else
		{
			// look for nearby target
			for (target in targets)
			{
				if (Util.dist(coords, target.getCoords(clock)) < kFindRadius)
				{
					findTime = clock.time + Util.lerp(3, 5, Math.random());
					foundCoords = target.getCoords(clock);
					foundTarget = target;
					break;
				}
			}
		}

		if (done)
		{
			Util.setPos(pixelSprite, area.coordsToScreen(coords));
			pixelSprite.x += (Math.random() < 0.5 ? -1 : 1);
			pixelSprite.y += (Math.random() < 0.5 ? -1 : 1);
			pixelSprite.x = Math.floor(pixelSprite.x - pixelSprite.width/2);
			pixelSprite.y = Math.floor(pixelSprite.y - pixelSprite.height/2);
		}
		else
		{
			super.updatePixelSprite(coords, 8);
		}
	}

	public override function draw()
	{
	}
}
