package ;

import flixel.util.FlxPoint;
import flixel.FlxSprite;

class Icon extends FlxSprite
{
	var lerpPos0:FlxPoint;
	var lerpPos1:FlxPoint;
	var lerp:Float;
	public var originalStack(default,null):IconStack;
	public var toolSpec(get,never):ToolSpec;
	function get_toolSpec() { return originalStack.toolSpec; }

	public function new(pos:FlxPoint, originalStack_:IconStack, imageFilename:String)
	{
		super(pos.x, pos.y);
		originalStack = originalStack_;
		loadGraphic("assets/images/" + imageFilename, toolSpec.iconUseSecondFrameOnArea);
	}

	public override function update()
	{
		if (lerpPos1 != null)
		{
			lerp += 0.1;
			if (lerp >= 1.0)
			{
				setPosition(lerpPos1.x, lerpPos1.y);
				lerpPos1 = null;
				lerpPos0 = null;
				lerp = 0;
			}
			else
			{
				var t = 1-Math.pow(1-lerp, 4);
				setPosition(
					lerpPos0.x + t * (lerpPos1.x - lerpPos0.x),
					lerpPos0.y + t * (lerpPos1.y - lerpPos0.y)
				);
			}
		}
	}

	public function setPos(pos:FlxPoint, lerpTo:Bool=false)
	{
		if (lerpTo)
		{
			lerpPos0 = new FlxPoint(x,y);
			lerpPos1 = pos;
			lerp = 0;
		}
		else
		{
			x = pos.x;
			y = pos.y;
		}
	}
}