package;

import flixel.FlxSprite;
import flixel.FlxG;
import flixel.text.FlxText;
import flash.display.StageQuality;
import flash.display.Stage;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.Lib;
import flixel.FlxGame;
import flixel.FlxState;

class Main extends Sprite 
{
	var gameWidth:Int = 512; // Width of the game in pixels (might be less / more in actual pixels depending on your zoom).
	var gameHeight:Int = 342; // Height of the game in pixels (might be less / more in actual pixels depending on your zoom).
	var initialState:Class<FlxState> = TitleState; // The FlxState the game starts with.
	var zoom:Float = 1; // If -1, zoom is automatically calculated to fit the window dimensions.
	var framerate:Int = 60; // How many frames per second the game should run at.
	var skipSplash:Bool = true; // Whether to skip the flixel splash screen that appears in release mode.
	var startFullscreen:Bool = false; // Whether to start the game in fullscreen on desktop targets
	
	// You can pretty much ignore everything from here on - your code should go in your states.

	public static var BLUE:Int = 0xff226594;
	public static var GREEN:Int = 0xffb1f2b1;
	public static var ORANGE:Int = 0xf5ad78;

	public static function main():Void
	{	
		Lib.current.addChild(new Main());
		Lib.current.stage.quality = StageQuality.LOW;
	}
	
	public function new() 
	{
		super();
		
		if (stage != null) 
		{
			init();
		}
		else 
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
	}
	
	private function init(?E:Event):Void 
	{
		if (hasEventListener(Event.ADDED_TO_STAGE))
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		setupGame();
	}
	
	private function setupGame():Void
	{
		var stageWidth:Int = Lib.current.stage.stageWidth;
		var stageHeight:Int = Lib.current.stage.stageHeight;

		if (zoom == -1)
		{
			var ratioX:Float = stageWidth / gameWidth;
			var ratioY:Float = stageHeight / gameHeight;
			zoom = Math.min(ratioX, ratioY);
			gameWidth = Math.ceil(stageWidth / zoom);
			gameHeight = Math.ceil(stageHeight / zoom);
		}

		addChild(new FlxGame(gameWidth, gameHeight, initialState, zoom, framerate, framerate, skipSplash, startFullscreen));
	}

	static var playingMusicName:String;
	public static function playMusic(name:String)
	{
		if (name == playingMusicName) return;
		playingMusicName = name;
		if (name == null)
		{
			if (FlxG.sound.music != null) FlxG.sound.music.fadeOut(2, 0);
		}
		else
		{
			FlxG.sound.playMusic("assets/music/" + name);
		}
	}
}