package;

import flixel.FlxGame;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.FlxState;
import flixel.text.FlxText;
import flixel.ui.FlxButton;
import flixel.util.FlxMath;

/**
 * A FlxState which can be used for the game's menu.
 */
class TitleState extends FlxState
{
	var clock:Clock = new Clock();
	var flashingTitleText:FlxSprite;

	override public function create():Void
	{
		FlxG.mouse.load("assets/images/MouseCursor.png", 2);

		var background = new FlxSprite(0,0);
		background.loadGraphic("assets/images/Screen-Title.png");
		add(background);

		flashingTitleText = new FlxSprite(0,0);
		flashingTitleText.loadGraphic("assets/images/Screen-TitleText.png");
		add(flashingTitleText);

		var nextButton = new ImageButton(430, 305, "Button-TitleNext.png", onNextClicked);
		add(nextButton);

		Main.playMusic("Softap.mp3");

		super.create();
	}
	
	override public function destroy():Void
	{
		super.destroy();
	}

	function onNextClicked()
	{
		FlxG.switchState(new MissingState());
	}

	override public function update():Void
	{
		super.update();
		clock.update();
		flashingTitleText.visible = clock.getFlashing(0.75, 0.9);
	}
}