package ;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flixel.text.FlxText;
import flixel.util.FlxPoint;
import flixel.group.FlxGroup;

class ToolInfoPanel extends FlxGroup
{
	var pos:FlxPoint;
	var text:FlxText;
	var photoSprite:FlxSprite;

	public function new(pos_:FlxPoint, width:Int, photoX:Float)
	{
		super();
		pos = pos_;

		text = Util.makeText("", width, Main.GREEN, "left");
		Util.setPos(text, pos);
		add(text);

		photoSprite = new FlxSprite(0,0);
		photoSprite.x = photoX;
		photoSprite.y = pos.y;
		add(photoSprite);

		visible = false;
	}

	public function set(toolSpec:ToolSpec)
	{
		visible = (toolSpec != null);
		if (!visible) return;

		text.text = toolSpec.name + "\n\n" + toolSpec.description + "\n\n";// + Std.int(toolSpec.errorRate * 100) + "% error rate";
		photoSprite.loadGraphic("assets/images/" + toolSpec.photoFilename);
	}
}
