package search;

import haxe.Serializer;
import flash.net.SharedObject;
import flash.geom.Point;

typedef Config =
{
	public var dim:{x:Int,y:Int};
	public var numTargets:Int;
	public var targetInset:Float;
	public var numPeoplePerTarget:Int;
	public var timeLimit:Float;
	public var toolSpace:{x:Int,y:Int};
	public var toolConfigs:Array<ToolConfig>;
}

typedef ToolConfig =
{
	public var id:String;
	public var count:Int;
}

enum SaveStatus
{
	RESCUED_NONE;
	RESCUED_SOME;
	RESCUED_ALL;
}

class SaveData
{
	public static var kCurVersion:Int = 2;
	public var version:Int = 2;
	public var statuses:Array<Int> = [];

	public function new()
	{
		load();
	}

	public function load()
	{
		try
		{
			var sov = SharedObject.getLocal("Version", "/");
			if (sov.data.version == kCurVersion)
			{
				var sos = SharedObject.getLocal("Status", "/");
				statuses = (sos.data.status == null || !Std.is(sos.data.status, Array)) ? null : sos.data.status.copy();
			}
		}
		catch (d:Dynamic)
		{}
	}

	public function save()
	{
		try
		{
			var sov = SharedObject.getLocal("Version", "/");
			sov.data.version = kCurVersion;
			sov.flush();

			var sos = SharedObject.getLocal("Status", "/");
			sos.data.status = statuses.copy();
			sos.flush();
		}
		catch (d:Dynamic)
		{}
	}
}

class Helper
{
	private static var saveData:SaveData = new SaveData();

	public static function getSaveStatus(config:Config):SaveStatus
	{
		var index = Lambda.indexOf(all, config);
		if (index >= 0)
			return Type.allEnums(SaveStatus)[saveData.statuses[index]];
		else
			return RESCUED_NONE;
	}

	public static function setSaveStatus(config:Config, saveStatus:SaveStatus)
	{
		var index = Lambda.indexOf(all, config);
		if (index >= 0 && (Type.enumIndex(saveStatus) > saveData.statuses[index]))
		{
			saveData.statuses[index] = Type.enumIndex(saveStatus);
			saveData.save();
		}
	}

	public static var all:Array<Config> = [
	{
		dim: {x:10,y:5},
		numTargets: 1,
		targetInset: 2,
		numPeoplePerTarget: 10,
		timeLimit: 60,
		toolSpace: {x:5, y:5},
		toolConfigs: [
			{ id:"sub", count:1 },
			{ id:"sonic", count:3 },
		]
	},
	{
		dim: {x:14,y:7},
		numTargets: 1,
		targetInset: 0.5,
		numPeoplePerTarget: 20,
		timeLimit: 60,
		toolSpace: {x:7, y:5},
		toolConfigs: [
			{ id:"sub", count:2 },
			{ id:"sonic", count:3 },
			{ id:"radio", count:2 }
		]
	},
	{
		dim: {x:20,y:10},
		numTargets: 2,
		targetInset: 0.5,
		numPeoplePerTarget: 50,
		timeLimit: 1.5*60,
		toolSpace: {x:11, y:6},
		toolConfigs: [
			{ id:"sub", count:2 },
			{ id:"sonic", count:3 },
			{ id:"radio", count:2 },
			{ id:"randomboats", count:1 },
			{ id:"lineboats", count:1 }
		]
	},
	{
		dim: {x:30,y:15},
		numTargets: 3,
		targetInset: 0.5,
		numPeoplePerTarget: 60,
		timeLimit: 2*60,
		toolSpace: {x:13, y:11},
		toolConfigs: [
			{ id:"sub", count:3 },
			{ id:"sonic", count:4 },
			{ id:"radio", count:4 },
			{ id:"randomboats", count:3 },
			{ id:"lineboats", count:3 },
			{ id:"flyby", count:3 }
		]
	},
	{
		dim: {x:36,y:18},
		numTargets: 1,
		targetInset: 0.5,
		numPeoplePerTarget: 45,
		timeLimit: 2.5*60,
		toolSpace: {x:11, y:7},
		toolConfigs: [
			{ id:"sub", count:3 },
			{ id:"sonic", count:4 },
			{ id:"radio", count:4 },
			{ id:"randomboats", count:3 },
			{ id:"lineboats", count:3 },
			{ id:"flyby", count:3 },
			{ id:"gps", count:1 },
			{ id:"path", count:1 }
		]
	},
	{
		dim: {x:50,y:25},
		numTargets: 3,
		targetInset: 0.5,
		numPeoplePerTarget: 100,
		timeLimit: 3*60,
		toolSpace: {x:11, y:9},
		toolConfigs: [
			{ id:"sub", count:4 },
			{ id:"sonic", count:4 },
			{ id:"radio", count:4 },
			{ id:"randomboats", count:2 },
			{ id:"lineboats", count:2 },
			{ id:"flyby", count:2 },
			{ id:"gps", count:2 },
			{ id:"path", count:1 }
		]
	},
	{
		dim: {x:60,y:30},
		numTargets: 2,
		targetInset: 0.5,
		numPeoplePerTarget: 40,
		timeLimit: 3.5*60,
		toolSpace: {x:13, y:9},
		toolConfigs: [
			{ id:"sub", count:2 },
			{ id:"sonic", count:4 },
			{ id:"radio", count:4 },
			{ id:"randomboats", count:2 },
			{ id:"lineboats", count:2 },
			{ id:"flyby", count:2 },
			{ id:"gps", count:2 },
			{ id:"path", count:1 },
			{ id:"steve", count:1 }
		]
	}
	];
}