package search;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flash.geom.Point;
import flash.display.Graphics;

class ToolBoats extends Tool
{
	var boats:Array<Boat>;
	static var kSpottingDuration = 5;
	static var kTargetSpottedOffset = 0.1;

	public function new(area_:Area, errorRate_:Float)
	{
		super(area_, errorRate_);
		boats = new Array<Boat>();
	}

	public inline function addBoat(boat:Boat, checkForTargets:Bool=true)
	{
		boats.push(boat);

		if (checkForTargets)
		{
			boat.whenFoundTargetAndGetShouldLoiter = boat_onFoundTarget;
		}
	}

	function boat_onFoundTarget(target:Target)
	{
		spottings.add(target.getCoords(clock), kSpottingDuration);

		// make the boat loiter here
		return true;
	}

	public override function destroy()
	{
		super.destroy();
		for (boat in boats)
		{
			boat.destroy();
		}
		boats = null;
	}

	public override function update()
	{
		super.update();
		for (boat in boats)
		{
			boat.update(area.clock);
		}
	}

	public override function draw()
	{
		if (!spottings.hasLiving) return;

		var patternBitmapData = openfl.Assets.getBitmapData("assets/images/Pattern-Boat.png");
		for (spotting in spottings.getAlive())
		{
			var graphics = canvas.beginPatternDraw(patternBitmapData);
			graphics.drawCircle(spotting.coords.x, spotting.coords.y, 0.25);
			graphics.drawCircle(spotting.coords.x, spotting.coords.y, 0.25-area.onePixel);
			canvas.endDraw();
		}
	}
}

