package search;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flash.geom.Point;
import flash.display.Graphics;

class ToolGangWander extends ToolBoats
{
	public static var kErrorRate = 0.2;
	public static var kAcquireTime = 20;

	public function new(area_:Area, c0:Point=null, c1:Point=null)
	{
		super(area_, kErrorRate);

		for (i in 0...10)
		{
			var boat = new Boat(area,
				"Tool-Boat.png",
				Util.lerp(0.004, 0.007, Math.random()), // speed
				Util.lerp(0.8, 1.25, Math.random()), // sightRadius
				targets
			);

			var waypoints = new Array<Point>();
			waypoints.push(new Point(Math.random() * area.dim.x, Math.random() * area.dim.y));
			for (i in 0...5)
			{
				while (true)
				{
					var p = new Point(Math.random() * area.dim.x, Math.random() * area.dim.y);
					if (Util.dist(p, waypoints[waypoints.length-1]) < area.dim.x*0.5) continue;
					waypoints.push(p);
					break;
				}
			}
			boat.setWaypoints(waypoints, true);
			addBoat(boat);
		}
	}
}

