package search;

import flash.geom.Rectangle;
import flash.geom.Point;

class ToolPath extends Tool
{
	var startTime:Float;
	var lastDrawnPointIndex:Int;
	var curPointIndex:Int;
	var advanceCountdown:Float;
	var entryPaths:Array<Array<Point>>;

	static var kDelayBetweenPoints = 0.1;

	public static var kErrorRate:Float = 0.15;
	public static var kAcquireTime:Float = 10;

	public function new(area_:Area, c0:Point=null, c1:Point=null)
	{
		super(area_, kErrorRate);
		startTime = clock.time;

		lastDrawnPointIndex = -1;
		advanceCountdown = kDelayBetweenPoints;

		entryPaths = [];
		for (target in area.targets)
		{
			entryPaths.push(target.buildEntryPath());
		}
	}

	public override function update()
	{
		advanceCountdown -= clock.dt;
		while (advanceCountdown < 0)
		{
			advanceCountdown += kDelayBetweenPoints;
			curPointIndex++;
		}
	}

	public override function draw()
	{
		for (entryPath in entryPaths)
		{
			if (lastDrawnPointIndex >= entryPath.length) continue;
			var fromPointIndex = lastDrawnPointIndex+1;
			for (i in fromPointIndex...curPointIndex)
			{
				if (i >= entryPath.length) break;
				var p = entryPath[i];

				var graphics = canvas.beginPatternDraw(openfl.Assets.getBitmapData("assets/images/Pattern-Path.png"), false);
				graphics.drawCircle(p.x, p.y, Util.lerp(0.1, 0.25, Math.random()));
				canvas.endDraw();
			}
		}

		lastDrawnPointIndex = curPointIndex-1;
	}
}
