package search;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flash.geom.Point;
import flash.display.Graphics;

class ToolRadioBuoy extends Tool
{
	public static var kMaxRadius = 3;
	public static var kErrorRate = 0.1;
	public static var kAcquireTime = 6;

	var coords:Point;
	var startTime:Float;

	public function new(area_:Area, c0:Point, c1:Point=null)
	{
		super(area_, kErrorRate);
		super.makePixelSprite("Tool-RadioBuoy.png");
		coords = c0;

		startTime = clock.time;
	}

	public override function update()
	{
		super.update();
		super.updatePixelSprite(coords);
	}

	public override function draw()
	{
		var graphics = canvas.beginSolidDraw(Main.BLUE);

		var targetAngles = new Array<Float>();
		for (target in targets)
		{
			var targetCoords = target.getCoords(clock);
			if (Util.dist(targetCoords, coords) > kMaxRadius) continue;
			var dx = targetCoords.x - coords.x;
			var dy = targetCoords.y - coords.y;
			targetAngles.push(Math.atan2(dy, dx));
		}
		var angleSpread = Util.lerpScale(clock.time-startTime, 0, kAcquireTime, Math.PI*2.0, Math.PI*Util.lerp(0.08, 0.2, Math.random()));

		for (i in 0...100)
		{
			var radius = kMaxRadius * Math.random();

			var angle = 0.0;
			if (targetAngles.length > 0)
			{
				var targetAngle = targetAngles[Std.int(targetAngles.length * Math.random())];
				angle = targetAngle + (2*2*Math.PI) + (angleSpread*Util.lerp(-1, 1, Math.random()));
			}
			else
			{
				angle = 2 * Math.PI * Math.random();
			}

			var x = coords.x + radius * Math.cos(angle);
			var y = coords.y + radius * Math.sin(angle);
			graphics.drawRect(x, y, area.onePixel, area.onePixel);
		}
		canvas.endDraw();
	}
}
