package search;

import flixel.FlxSprite;
import flixel.util.FlxColor;
import flash.geom.Point;
import flash.display.Graphics;

class ToolSteve extends ToolBoats
{
	public static var kErrorRate = 0.1;
	public static var kAcquireTime = 20;
	public static var kLineWidth = 5;
	public static var kLineLen = 10;

	public function new(area_:Area, c0:Point=null, c1:Point=null)
	{
		super(area_, kErrorRate);

		var boat = new Boat(
			area,
			"Tool-Boat.png",
			0.025, // speed
			0.5, // sightRadius
			targets
		);

		var waypoints = new Array<Point>();
		waypoints.push(new Point(Math.random() * area.dim.x, Math.random() * area.dim.y));
		for (i in 0...20)
		{
			while (true)
			{
				var p = new Point(Math.random() * area.dim.x, Math.random() * area.dim.y);
				if (Util.dist(p, waypoints[waypoints.length-1]) < area.dim.x*0.25) continue;
				waypoints.push(p);
				break;
			}
		}
		boat.setWaypoints(waypoints, true);
		addBoat(boat);
	}
}

