package ;
import flixel.FlxSprite;
import flixel.tweens.FlxEase;
import flixel.tweens.FlxTween;
import flixel.group.FlxSpriteGroup;

class ButtonBar extends FlxSpriteGroup
{
	var desk:Desk;
	var signButton:ImageButton;
	var sealButton:ImageButton;
	var deliverButton:ImageButton;

	var kHideY = 360;
	var kShowY = 323;

	public function new(desk_:Desk)
	{
		super();

		desk = desk_;

		var back = new FlxSprite();
		add(back);

		signButton = new ImageButton("assets/images/Button-Sign.png", onClickSign);
		signButton.clickChecker.buttonUpSound = "Sign.mp3";
		add(signButton);

		sealButton = new ImageButton("assets/images/Button-Seal.png", onClickSeal);
		sealButton.clickChecker.buttonUpSound = "Seal.mp3";
		sealButton.x = signButton.x + signButton.width;
		add(sealButton);

		deliverButton = new ImageButton("assets/images/Button-Deliver.png", onClickDeliver);
		deliverButton.clickChecker.buttonUpSound = null;
		deliverButton.x = sealButton.x + sealButton.width;
		add(deliverButton);

		back.makeGraphic(Std.int(signButton.width + sealButton.width + deliverButton.width), Std.int(signButton.height), 0xff808080);

		x = 188;
		y = kHideY;
	}

	function onClickSign()
	{
		signButton.visible = false;
		desk.processForm(SIGN);
	}

	function onClickSeal()
	{
		sealButton.visible = false;
		signButton.visible = false;
		desk.processForm(SEAL);
	}

	function onClickDeliver()
	{
		sealButton.visible = false;
		signButton.visible = false;
		deliverButton.visible = false;
		animateVisible(false);
		desk.processForm(DELIVER);
	}

	public function resetToUnclicked()
	{
		signButton.visible = true;
		sealButton.visible = true;
		deliverButton.visible = true;
	}

	public function animateVisible(v:Bool)
	{
		if (v)
			FlxTween.tween(this, { y: kShowY }, 0.2, { ease:FlxEase.sineOut, startDelay:0.5 });
		else
			FlxTween.tween(this, { y: kHideY }, 0.2, { ease:FlxEase.sineIn });
	}
}
