package ;

import flixel.text.pxText.PxTextAlign;
import flixel.FlxSprite;
import flixel.FlxG;
import flixel.util.FlxPoint;
import openfl.geom.Rectangle;
import flixel.text.FlxBitmapTextField;
import flixel.group.FlxSpriteGroup;
import flixel.addons.ui.FlxUI9SliceSprite;

class ComboBox extends FlxSpriteGroup
{
	var back:FlxUI9SliceSprite;
	var texts = new Array<FlxBitmapTextField>();
	var highlight:FlxSprite;
	var onSelected:String->Void;
	var numFramesOpen:Int;

	static var kPadding = 4;
	static var kLineHeight = 11;
	public static var kMaxItems = 12;

	public function new()
	{
		super();

		back = new FlxUI9SliceSprite(0, 0, "assets/images/ListFrame.png", new Rectangle(0,0,20,20), [ 4, 4, 18, 18 ]);
		add(back);

		highlight = new FlxSprite();
		add(highlight);

		for (i in 0...kMaxItems)
		{
			var text = new FlxBitmapTextField(Global.formFont);
			text.fixedWidth = true;
			text.alignment = PxTextAlign.CENTER;
			texts.push(text);
			add(text);
		}

		visible = false;
	}

	public function open(x_:Float, y_:Float, width:Float, items:Array<String>, selectedItem:String, onSelected_:String->Void)
	{
		if (!Capture.take(this)) return;

		onSelected = onSelected_;

		var itemsHeight = items.length * kLineHeight;

		var selectedIndex = Lambda.indexOf(items, selectedItem);
		if (selectedIndex < 0) selectedIndex = Std.int(items.length/2);

		x = x_;
		y = y_ - selectedIndex * kLineHeight + kPadding + 1;
		visible = true;

		back.resize(width + 2 * kPadding, itemsHeight + 2 * kPadding + 1);
		back.x = x - kPadding;
		back.y = y - kPadding;

		highlight.makeGraphic(Std.int(width), kLineHeight, 0xff808080);
		highlight.x = x_;
		highlight.visible = false;

		for (i in 0...items.length)
		{
			if (i > texts.length) break;

			var text = texts[i];
			text.text = items[i];
			text.width = width;
			text.textColor = 0x808080;
			text.x = x;
			text.y = y + i * kLineHeight - 5;
			text.visible = true;
		}

		for (i in items.length...texts.length)
		{
			texts[i].visible = false;
		}

		numFramesOpen = 0;

		Main.playSound("Combo-Open.mp3");
	}

	public function close()
	{
		visible = false;
		Capture.release(this);
	}

	public override function update()
	{
		super.update();

		if (visible)
		{
			if (!Capture.take(this))
			{
				close();
				return;
			}

			var selectedText = null;
			var kShiftY = -4;
			var mouse = new FlxPoint(FlxG.mouse.screenX, FlxG.mouse.screenY);

			for (i in 0...texts.length)
			{
				var text = texts[i];
				if (!text.visible) break;

				var topY = y + kPadding + i * kLineHeight + kShiftY;
				var botY = y + kPadding + (i+1) * kLineHeight + kShiftY;

				if (mouse.y >= topY &&	mouse.y < botY)
				{
					selectedText = text;
					text.textColor = 0xffffff;
					highlight.y = topY;
				}
				else
				{
					text.textColor = 0x808080;
				}
			}

			highlight.visible = (selectedText != null);

			if (Capture.justPressed(this) && numFramesOpen > 1)
			{
				if (selectedText != null && onSelected != null) onSelected(selectedText.text);
				close();
				Main.playSound("Combo-Select.mp3");
			}

			numFramesOpen++;
		}

	}
}



