package ;

import flixel.FlxG;
import flixel.util.FlxPoint;
import flixel.text.pxText.PxTextAlign;
import openfl.Assets;
import flixel.text.pxText.PxBitmapFont;
import flixel.text.FlxBitmapTextField;
import flixel.text.FlxText;

class Field extends FlxBitmapTextField
{
	public var id(default,null):String;

	var formId:String;
	var desk:Desk;
	var locked:Bool;
	var clickChecker:ClickChecker;
	var lockColor:Int;
	var unlockColor:Int;
	var paperColor:Int;

	public function new(desk_:Desk, formId_:String, id_:String, unlockColor_:Int, lockColor_:Int, paperColor_:Int)
	{
		super(Global.formFont);

		desk = desk_;
		formId = formId_;
		id = id_;
		unlockColor = unlockColor_;
		lockColor = lockColor_;
		paperColor = paperColor_;

		textColor = unlockColor;

		fixedWidth = true;
		alignment = PxTextAlign.CENTER;

		clickChecker = new ClickChecker(this);
		clickChecker.buttonUpSound = null;
	}

	public override function update()
	{
		super.update();

		if (!locked)
		{
			var clickResult = clickChecker.update();
			var hover = (clickResult & ClickChecker.HOVER) != 0;
			var click = (clickResult & ClickChecker.CLICK) != 0;

			if (hover && !background)
			{
				// invert
				background = true;
				backgroundColor = 0xff000000 | unlockColor;
				textColor = paperColor;
			}
			else if (!hover && background)
			{
				// normal
				background = false;
				textColor = unlockColor;
				backgroundColor = 0x0;
			}

			if (click)
			{
				desk.comboBox.open(x, y, width, desk.getFieldList(formId, id), text, onComboBoxSelected);
			}
		}
		else
		{
			background = false;
		}
	}

	public function lock(locked_:Bool)
	{
		locked = locked_;
		textColor = locked ? lockColor : unlockColor;
		background = false;
	}

	function onComboBoxSelected(value:String)
	{
		text = value;
	}
}
