package;
import openfl.geom.Rectangle;
import flixel.group.FlxSpriteGroup;
import flixel.util.FlxBitmapUtil;
import haxe.xml.Fast;
import flixel.util.FlxPoint;
import flixel.group.FlxGroup;
import flixel.text.FlxText;
import flixel.FlxSprite;

class Folder extends FlxSpriteGroup
{
	public var form:Form;

	var top:ImageButton;
	var bottom:FlxSprite;
	var desk:Desk;

	public function new(desk_:Desk, fast:Fast, x_:Int, y_:Int)
	{
		super();

		desk = desk_;

		top = new ImageButton("assets/images/Folder-" + fast.att.id + ".png", onClick);
		top.hitRect = new Rectangle(13, 0, 69, 18);
		top.clickChecker.buttonUpSound = "ClickFolder.mp3";
		add(top);

		form = new Form(desk, fast, new FlxPoint(x_+2, y_+22));
		add(form);

		bottom = new FlxSprite();
		bottom.loadGraphic("assets/images/FolderBottom.png");
		bottom.y = top.height;
		add(bottom);

		x = x_;
		y = y_;
	}

	public function clearTabHitRect()
	{
		top.hitRect = null;
	}

	function onClick()
	{
		desk.showForm(this.form);
	}
}
