package;

import openfl.Assets;
import flixel.text.pxText.PxBitmapFont;
import flixel.util.FlxSave;

class Global
{
	public static var formFont(get,null):PxBitmapFont;
	public static var lcdFont(get,null):PxBitmapFont;
	public static var terminalFont(get,null):PxBitmapFont;

	static function get_formFont()
	{
		if (formFont == null) formFont = loadFont("pf_westa_seven_condensed_regular_8");
		return formFont;
	}

	static function get_lcdFont()
	{
		if (lcdFont == null) lcdFont = loadFont("Lcd");
		return lcdFont;
	}

	static function get_terminalFont()
	{
		if (terminalFont == null) terminalFont = loadFont("proggytinytt_regular_16");
		return terminalFont;
	}

	static function loadFont(name:String)
	{
		var font = new PxBitmapFont();
		font.loadAngelCode(
			Assets.getBitmapData("assets/images/" + name + ".png"),
			Xml.parse(Assets.getText("assets/images/" + name + ".fnt"))
		);
		return font;
	}
}