package ;

import openfl.geom.Rectangle;
import flixel.util.FlxPoint;
import flixel.FlxG;
import flixel.FlxSprite;

class ImageButton extends FlxSprite
{
	var onClick:Void->Void;
	public var clickChecker:ClickChecker;

	public var hitRect(get,set):Rectangle; function get_hitRect() { return clickChecker.hitRect; } function set_hitRect(r) { return clickChecker.hitRect = r; }
	public var enabled:Bool = true;

	public function new(imageFilename:String, ?onClick_:Void->Void)
	{
		super();
		var bitmapData = openfl.Assets.getBitmapData(imageFilename);
		loadGraphic(bitmapData, true, bitmapData.width, Std.int(bitmapData.height/2));
		onClick = onClick_;
		clickChecker = new ClickChecker(this);
	}

	public override function update()
	{
		super.update();

		var clickResult = clickChecker.update();
		var hover = (clickResult & ClickChecker.HOVER) != 0;
		var click = (clickResult & ClickChecker.CLICK) != 0;

		frame = framesData.frames[hover ? 1 : 0];
		if (click && onClick != null) onClick();
	}
}
