package ;

import openfl.Assets;

class Name
{
	public var first(default,null):String;
	public var last(default,null):String;
	public var male(default,null):Bool;

	public var family(get,never):String; function get_family() { return last + " Family"; }
	public var full(get,never):String; function get_full() { return first + " " + last; }

	private function new(first_:String, last_:String, male_:Bool)
	{
		first = first_;
		last = last_;
		male = male_;
	}

	static var firstsM:Array<String>;
	static var firstsF:Array<String>;
	static var lasts:Array<String>;

	public static function next(male:Bool, consumeLastName:Bool=true)
	{
		if (lasts == null) load();


		var first = male ? firstsM[Std.random(firstsM.length)] : firstsF[Std.random(firstsM.length)];
		var last = lasts[Std.random(lasts.length)];

		if (consumeLastName)
		{
			// can only use each last name once between resets
			lasts.remove(last);
		}

		return new Name(first, last, male);
	}

	public static function reset()
	{
		load();
	}

	static function load()
	{
		firstsM = Assets.getText("assets/data/NamesFirstM.txt").split("\n");
		firstsF = Assets.getText("assets/data/NamesFirstF.txt").split("\n");
		lasts = Assets.getText("assets/data/NamesLast.txt").split("\n");
	}
}
