package ;

import lime.Assets;
import haxe.xml.Fast;
using StringTools;

class Session
{
	public var index:Int;
	public var duration:Float;
	public var formIds:Array<String>;
	public var screenId:String;
	public var wait:Bool;
	public var jobCount:Int;

	public function new(index_:Int, fast:Fast)
	{
		index = index_;
		duration = Std.parseInt(fast.att.duration);
		formIds = fast.att.forms.split(",");
		for (i in 0...formIds.length) formIds[i] = formIds[i].trim();

		screenId = fast.att.screen;
		wait = fast.has.wait && fast.att.wait == "true";
		jobCount = fast.has.count ? Std.parseInt(fast.att.count) : 0;
	}

	public static var failedSessionIndex:Int = -1;

	public static var cur(get,null):Session;

	public static var allSessions:Array<Session>;

	static function get_cur()
	{
		if (allSessions == null)
		{
			loadAllSessions();
			cur = allSessions[0];
		}
		return cur;
	}

	static function loadAllSessions()
	{
		var xml = Xml.parse(Assets.getText("assets/data/Sessions.xml"));
		var fast = new Fast(xml.firstElement());
		allSessions = new Array<Session>();
		var index = 0;
		for (sessionFast in fast.nodes.session)
		{
			allSessions.push(new Session(index, sessionFast));
			index++;
		}
	}

	public static function advanceCur()
	{
		if (allSessions == null)
		{
			loadAllSessions();
			cur = allSessions[0];
		}
		cur = allSessions[(cur.index + 1) % allSessions.length];
	}

	public static function resetForNewGame()
	{
		if (allSessions == null) loadAllSessions();
		cur = allSessions[0];
		failedSessionIndex = -1;
	}
}
