package ;

import flixel.FlxG;
import flixel.text.FlxBitmapTextField;

class Terminal extends FlxBitmapTextField
{
	var targetText:String;
	var animateElapsed:Float;

	static var kDefaultText = "SELECT ALERT ABOVE\nFOR DETAILS";
	public static var kMaxLineWidth = 25;

	public function new()
	{
		//super(Global.lcdFont);
		super(Global.terminalFont);

		animateElapsed = 10000;
		wordWrap = true;
		multiLine = true;
		text = " ";
		textColor = 0xc7ff85;
		//lineSpacing = 3;
		animateText(kDefaultText);
	}

	public function animateText(targetText_:String)
	{
		text = " ";
		targetText = targetText_;
		if (targetText == " ") targetText = kDefaultText;
		animateElapsed = 0;
	}

	public override function update()
	{
		super.update();

		if (animateElapsed < 1000)
		{
			// animate
			animateElapsed += FlxG.elapsed;

			if (animateElapsed > 0.05)
			{
				if (text.length >= targetText.length)
				{
					text = targetText;
					animateElapsed = 10000;
				}
				else
				{
					animateElapsed = 0;
					text = targetText.substr(0, text.length+1) + "|";
					Main.playSound("Terminal-Beep.mp3");
				}
			}
		}
	}
}
