package;

import flash.geom.Rectangle;
import flixel.FlxG;
import flixel.FlxSprite;
import flixel.FlxState;
import flixel.text.FlxText;
import flixel.ui.FlxButton;
import flixel.util.FlxMath;

/**
 * A FlxState which can be used for the game's menu.
 */
class TitleState extends FlxState
{
	/**
	 * Function that is called up when to state is created to set it up. 
	 */
	override public function create():Void
	{
		super.create();

		var back = new FlxSprite();
		back.loadGraphic("assets/images/Screen-Title.png");
		add(back);

		var goButton = new TextButton(new Rectangle(420, 325, 80, 27), "BEGIN", onClickBegin);
		add(goButton);

		FlxG.sound.playMusic("assets/music/Main.mp3", 1, true);

		FlxG.mouse.load("assets/images/MouseCursor.png", 2);
	}

	function onClickBegin()
	{
		Session.resetForNewGame();
		FlxG.switchState(new NightState());
	}

	/**
	 * Function that is called when this state is destroyed - you might want to 
	 * consider setting all objects this state uses to null to help garbage collection.
	 */
	override public function destroy():Void
	{
		super.destroy();
	}

	/**
	 * Function that is called once every frame.
	 */
	override public function update():Void
	{
		super.update();
	}	
}