package
{
	import org.flixel.*;
	
	public class Readership
	{
		public var curReaderCount:int;
		public var preReaderCount:int;
		public var curLoyalty:int;
		public var preLoyalty:int;		
		public var comments:String;
		
		public function Readership(loyalty:int=0, readers:int=Const.readershipStartCount) 
		{
			curLoyalty = loyalty;
			preLoyalty = loyalty;
			curReaderCount = readers;
			preReaderCount = readers;
		}
		
		private static function getReadershipBonus(readerCount:int):Number
		{
			return 1 + 0.1 * (Math.floor((readerCount - Const.readershipStartCount) / Const.readershipBonusThresh));
		}
		
		public function getReaderCountDelta():int
		{
			return curReaderCount - preReaderCount;
		}

		public function getLoyaltyDelta():int
		{
			return curLoyalty - preLoyalty;
		}
		
		public function toString():String
		{
			var str:String = "L:" + curLoyalty + "(" + getLoyaltyDelta() + ") ";
			str += "R:" + curReaderCount + "(" + getReaderCountDelta() + ") ";
			return str;
		}
		
		public function applyPaperSummary(paperSummary:PaperSummary):void
		{
			preLoyalty = curLoyalty;
			preReaderCount = curReaderCount;
			
			comments = "";
			curLoyalty += paperSummary.totalLoyaltyEffect * getReadershipBonus(preReaderCount);
			if (curLoyalty > Const.statMax) curLoyalty = Const.statMax;
			if (curLoyalty < -Const.statMax) curLoyalty = -Const.statMax;
			
			if (paperSummary.articleCoveragePercentage == 0)
			{
				comments += "* The paper is blank. Money was saved on ink, but you have lost many readers.\n";
				curReaderCount *= 0.5;
			}
			else if (paperSummary.articleCoveragePercentage < 0.75)
			{
				comments += "* There are too few articles. You have lost readers.\n";
				curReaderCount *= 0.75;
			}
			if (paperSummary.numInterestingArticles < 2)
			{
				comments += "* There are not enough interesting articles. You have lost readers.\n";
				curReaderCount *= 0.9;
			}
			else if (paperSummary.numInterestingArticles > 2)
			{
				comments += "* There are many interesting articles. You have gained readers.\n";
				curReaderCount *= 1.25;
			}
			
			if (curLoyalty > preLoyalty)
			{
				comments += "* The included articles have increased your readership's loyalty to the government.\n";
			}
			if (curLoyalty< preLoyalty)
			{
				comments += "* The included articles have decreased your readership's loyalty to the government.\n";
			}
			
			var preReadershipBonus:Number = getReadershipBonus(preReaderCount);
			var curReadershipBonus:Number = getReadershipBonus(curReaderCount);
			if (curReadershipBonus > preReadershipBonus)
			{
				comments += "* The paper's increasing readership has expanded its influence.\n";
			}
			else if (curReadershipBonus > preReadershipBonus)
			{
				comments += "* The paper's decreasing readership has reduced its influence.\n";
			}
		}
	}
}